using System;
using System.Data;
using gov.va.med.vbecs.ExceptionManagement;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// BOL functions for all reference data
	/// </summary>
	public class ReferenceData
	{
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7655"> 
		///		<ExpectedInput>Valid unit status code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7656"> 
		///		<ExpectedInput>Invalid unit status code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of UnitStatus data, based on UnitStatusCode.  
		/// </summary>
		/// <returns>DataRow of UnitStatus</returns>
		public static DataRow GetUnitStatus(string unitStatusCode)
		{
			return DAL.ReferenceData.GetUnitStatus(unitStatusCode);
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7657"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of unit status reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7658"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of UnitStatus, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all UnitStatus rows</returns>
		public static DataTable GetUnitStatusList()
		{
			return DAL.ReferenceData.GetUnitStatusList();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7659"> 
		///		<ExpectedInput>Valid blood type code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7660"> 
		///		<ExpectedInput>Invalid blood type code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of BloodType data, based on BloodTypeCode.  
		/// </summary>
		/// <returns>DataRow of BloodType</returns>
		public static DataRow GetBloodType(string bloodTypeCode)
		{
			return DAL.ReferenceData.GetBloodType(bloodTypeCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7661"> 
		///		<ExpectedInput>Valid antigen type id</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7662"> 
		///		<ExpectedInput>Invalid antigen type id</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of AntigenType data, based on AntigenTypeId.  
		/// </summary>
		/// <returns>DataRow of AntigenType</returns>
		public static DataRow GetAntigenType(int antigenTypeID)
		{
			return DAL.ReferenceData.GetAntigenType(antigenTypeID);
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7663"> 
		///		<ExpectedInput>Valid component class id</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7664"> 
		///		<ExpectedInput>Invalid component class id</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of ComponentClass data, based on ComponentClassId.  
		/// </summary>
		/// <returns>DataRow of ComponentClass</returns>
		public static DataRow GetComponentClass(int componentClassID)
		{
			return DAL.ReferenceData.GetComponentClass(componentClassID);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6340"> 
		///		<ExpectedInput>Valid lock function id</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6341"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of VbecsLockFunction data, based on LockFunctionId.  
		/// </summary>
		/// <returns>DataRow of VbecsLockFunction</returns>
		public static DataRow GetLockFunction(Common.LockFunctions lockFunctionId)
		{
			return DAL.ReferenceData.GetLockFunction(lockFunctionId);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7667"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of lock function reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7668"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of VbecsLockFunction, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all VbecsLockFunction rows</returns>
		public static DataTable GetLockFunctionList()
		{
			return DAL.ReferenceData.GetLockFunctionList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7669"> 
		///		<ExpectedInput>Valid specimen status code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7670"> 
		///		<ExpectedInput>Invalid specimen status code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of SpecimenStatus data, based on SpecimenStatusCode.  
		/// </summary>
		/// <returns>DataRow of SpecimenStatus</returns>
		public static DataRow GetSpecimenStatus(string specimenStatusCode)
		{
			return DAL.ReferenceData.GetSpecimenStatus(specimenStatusCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7671"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of specimen status reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7672"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of SpecimenStatus, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all SpecimenStatus rows</returns>
		public static DataTable GetSpecimenStatusList()
		{
			return DAL.ReferenceData.GetSpecimenStatusList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7673"> 
		///		<ExpectedInput>Valid task status code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7674"> 
		///		<ExpectedInput>Invalid task status code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of TaskStatus data, based on TaskStatusCode.  
		/// </summary>
		/// <returns>DataRow of TaskStatus</returns>
		public static DataRow GetTaskStatus(string taskStatusCode)
		{
			return DAL.ReferenceData.GetTaskStatus(taskStatusCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7675"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of task status reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7676"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of TaskStatus, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all ProductModification rows</returns>
		public static DataTable GetTaskStatusList()
		{
			return DAL.ReferenceData.GetTaskStatusList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7677"> 
		///		<ExpectedInput>Valid product modification code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7678"> 
		///		<ExpectedInput>Invalid product modification code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of ProductModification data, based on ProductModificationCode.  
		/// </summary>
		/// <returns>DataRow of ProductModification</returns>
		public static DataRow GetProductModification(string productModificationCode)
		{
			return DAL.ReferenceData.GetProductModification(productModificationCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7679"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of product modification reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7680"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of ProductModification, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all ProductModification rows</returns>
		public static DataTable GetProductModificationList()
		{
			return DAL.ReferenceData.GetProductModificationList();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7681"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of testing method reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7682"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of TestingMethod, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all TestingMethod rows</returns>
		public static DataTable GetTestingMethodList()
		{
			return DAL.ReferenceData.GetTestingMethodList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7683"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>String array of state codes</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7684"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetStateCodes
		/// </summary>
		/// <returns></returns>
		public static string[] GetStateCodes()
		{
			System.Collections.ArrayList alStateCodes = new System.Collections.ArrayList();
			System.Collections.ArrayList alStateNames = new System.Collections.ArrayList();

			foreach(DataRow dr in DAL.ReferenceData.GetStateList().Rows)
			{
				alStateCodes.Add(dr[Common.VbecsTables.State.StateCode].ToString());
				alStateNames.Add(dr[Common.VbecsTables.State.StateName].ToString());
			}

			return ((string[])alStateCodes.ToArray(typeof(string)));

			//_stateNames = (string[])alStateNames.ToArray(typeof(string));
		
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7685"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of test result reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7686"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of TestResult, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all TestResult rows</returns>
		public static DataTable GetTestResultList()
		{
			return DAL.ReferenceData.GetTestResultList();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/28/03</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7687"> 
		///		<ExpectedInput>Valid time zone id</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7688"> 
		///		<ExpectedInput>Invalid time zone id</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of TimeZone data, based on TimeZoneId.  
		/// </summary>
		/// <returns>DataRow of TimeZone</returns>
		public static DataRow GetTimeZone(string timeZoneID)
		{
			return DAL.ReferenceData.GetTimeZone(timeZoneID);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7689"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of transfusion reaction type reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7690"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of TransfusionReactionType, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetTransfusionReactionTypeList()
		{
			return DAL.ReferenceData.GetTransfusionReactionTypeList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7691"> 
		///		<ExpectedInput>Valid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7692"> 
		///		<ExpectedInput>Invalid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of TransfusionReactionType data, based on TransfusionReactionTypeCode.
		/// </summary>
		/// <param name="transfusionReactionTypeCode">Transfusion Reaction Type Code</param>
		/// <returns>DataRow of TransfusionReactionType</returns>
		public static DataRow GetTransfusionReactionType(char transfusionReactionTypeCode)
		{
			return DAL.ReferenceData.GetTransfusionReactionType(transfusionReactionTypeCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7693"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of orderable test reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7694"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetOrderableTestList
		/// </summary>
		/// <returns></returns>
		public static DataTable GetOrderableTestList()
		{
			return DAL.ReferenceData.GetOrderableTestList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7695"> 
		///		<ExpectedInput>Valid orderable test id</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7696"> 
		///		<ExpectedInput>Invalid orderable test id</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetOrderableTest
		/// </summary>
		/// <param name="orderableTestId"></param>
		/// <returns></returns>
		public static DataRow GetOrderableTest(int orderableTestId)
		{
			return DAL.ReferenceData.GetOrderableTest(orderableTestId);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7697"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of reactivity phase reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7698"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReactivityPhaseList
		/// </summary>
		/// <returns></returns>
		public static DataTable GetReactivityPhaseList()
		{
			return DAL.ReferenceData.GetReactivityPhaseList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7699"> 
		///		<ExpectedInput>Valid reactivity phase code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7700"> 
		///		<ExpectedInput>Invalid reactivity phase code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReactivityPhase
		/// </summary>
		/// <param name="reactivityPhaseCode"></param>
		/// <returns></returns>
		public static DataRow GetReactivityPhase(int reactivityPhaseCode)
		{
			return DAL.ReferenceData.GetReactivityPhase(reactivityPhaseCode);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7701"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of product type reference data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7702"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetProductTypeList
		/// </summary>
		/// <returns></returns>
		public static DataTable GetProductTypeList()
		{
			return DAL.ReferenceData.GetProductTypeList();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7703"> 
		///		<ExpectedInput>Valid product type code</ExpectedInput>
		///		<ExpectedOutput>Reference data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7704"> 
		///		<ExpectedInput>Invalid product type code</ExpectedInput>
		///		<ExpectedOutput>Data Access Layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetProductType
		/// </summary>
		/// <param name="productTypeCode"></param>
		/// <returns></returns>
		public static DataRow GetProductType(string productTypeCode)
		{
			return DAL.ReferenceData.GetProductType(productTypeCode);
		}
	}
}
